/**
 * 与此文件统计目录下的config_prod.js文件用于配置生产环境下的相关信息，当运行yarn build打包项目时，会自动使用config_prod.js文件的内容覆盖config.js的内容。
 * 友情提醒：config_prod.js文件只是一个临时文件，用于配置项目在打包到生成环境之后的config信息，不论是开发环境或是生产环境，PageNow使用的始终都是config.js这个文件。
 */
window.g = {
  /**
   * PROJECT_ROOT_NAME用于定义项目名称，此名称必须在开发环境下设置与vue.config.js配置文件中的publicPath属性保持一致
   * 备注：此变量在生产环境下【不可修改】
   */
  PROJECT_ROOT_NAME: '/pagenow',
  /**
   * 系统显示名称，此名称一般在系统运行时用于显示系统名称时使用，例如在管理界面左上角显示的名称
   * 备注：此变量在生产环境下【可修改】
   */
  SYS_NAME: 'PageNow',
  /**
   * 定义系统的显示版本号
   * 备注：此变量在生产环境下【可修改】
   */
  SYS_VERSION: '企业版-中科图新',
  /**
   * axios基础路径，此路径一般与PageNow后端运行程序的IP和端口号对应。
   * 当进行项目打包的时候，建议先将此变量设置为生产环境下的后端服务地址，当然，在打包之后，也可以在打包后的目录中，在static文件夹下找到config.js配置文件进行修改
   * 备注：此变量在生产环境下【可修改】
   */
  AXIOS_BASE_URL: 'http://10.16.30.105:8090',

  ECHARTTHEME: [{ "id": "00a1ef2a9a9d450e8b05babc3f7103fb", "name": "活力橙", "json_text": "{\"color\":[\"rgba(216,67,21,1)\",\"rgba(230,74,25,1)\",\"rgba(244,81,30,1)\",\"rgba(255,87,34,1)\",\"rgba(255,112,67,1)\",\"rgba(255,138,101,1)\",\"rgba(255,171,145,1)\",\"rgba(255,204,188,1)\"],\"backgroundColor\":\"\",\"textStyle\":{},\"title\":{\"textStyle\":{\"color\":\"#ffffff\"},\"subtextStyle\":{\"color\":\"#ffffff\"}},\"line\":{\"itemStyle\":{\"normal\":{\"borderWidth\":1}},\"lineStyle\":{\"normal\":{\"width\":2}},\"symbolSize\":4,\"symbol\":\"circle\",\"smooth\":false},\"radar\":{\"itemStyle\":{\"normal\":{\"borderWidth\":1}},\"lineStyle\":{\"normal\":{\"width\":2}},\"symbolSize\":4,\"symbol\":\"circle\",\"smooth\":false},\"bar\":{\"itemStyle\":{\"normal\":{\"barBorderWidth\":\"0\",\"barBorderColor\":\"#bdbdbd\"},\"emphasis\":{\"barBorderWidth\":\"0\",\"barBorderColor\":\"#bdbdbd\"}}},\"pie\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"scatter\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"boxplot\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"parallel\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"sankey\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"funnel\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"gauge\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"candlestick\":{\"itemStyle\":{\"normal\":{\"color\":\"#2196f3\",\"color0\":\"#90caf9\",\"borderColor\":\"#f44336\",\"borderColor0\":\"#8bc34a\",\"borderWidth\":\"0.5\"}}},\"graph\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}},\"lineStyle\":{\"normal\":{\"width\":1,\"color\":\"#ffffff\"}},\"symbolSize\":4,\"symbol\":\"circle\",\"smooth\":false,\"color\":[\"#0d47a1\",\"#1565c0\",\"#1976d2\",\"#1e88e5\",\"#2196f3\",\"#42a5f5\",\"#64b5f6\",\"#90caf9\"],\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#ffffff\"}}}},\"map\":{\"itemStyle\":{\"normal\":{\"areaColor\":\"#616161\",\"borderColor\":\"#424242\",\"borderWidth\":\"0.5\"},\"emphasis\":{\"areaColor\":\"#2196f3\",\"borderColor\":\"#424242\",\"borderWidth\":1}},\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#ffffff\"}},\"emphasis\":{\"textStyle\":{\"color\":\"#ffffff\"}}}},\"geo\":{\"itemStyle\":{\"normal\":{\"areaColor\":\"#616161\",\"borderColor\":\"#424242\",\"borderWidth\":\"0.5\"},\"emphasis\":{\"areaColor\":\"#2196f3\",\"borderColor\":\"#424242\",\"borderWidth\":1}},\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#ffffff\"}},\"emphasis\":{\"textStyle\":{\"color\":\"#ffffff\"}}}},\"categoryAxis\":{\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisTick\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisLabel\":{\"show\":true,\"textStyle\":{\"color\":\"#ffffff\"}},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":[\"#ffffff\"]}},\"splitArea\":{\"show\":false,\"areaStyle\":{\"color\":[\"#eeeeee\"]}}},\"valueAxis\":{\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisTick\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisLabel\":{\"show\":true,\"textStyle\":{\"color\":\"#ffffff\"}},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":[\"#ffffff\"]}},\"splitArea\":{\"show\":false,\"areaStyle\":{\"color\":[\"#eeeeee\"]}}},\"logAxis\":{\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisTick\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisLabel\":{\"show\":true,\"textStyle\":{\"color\":\"#ffffff\"}},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":[\"#ffffff\"]}},\"splitArea\":{\"show\":false,\"areaStyle\":{\"color\":[\"#eeeeee\"]}}},\"timeAxis\":{\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisTick\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisLabel\":{\"show\":true,\"textStyle\":{\"color\":\"#ffffff\"}},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":[\"#ffffff\"]}},\"splitArea\":{\"show\":false,\"areaStyle\":{\"color\":[\"#eeeeee\"]}}},\"toolbox\":{\"iconStyle\":{\"normal\":{\"borderColor\":\"#ffffff\"},\"emphasis\":{\"borderColor\":\"#2196f3\"}}},\"legend\":{\"textStyle\":{\"color\":\"#ffffff\"}},\"tooltip\":{\"axisPointer\":{\"lineStyle\":{\"color\":\"#e0e0e0\",\"width\":\"1\"},\"crossStyle\":{\"color\":\"#e0e0e0\",\"width\":\"1\"}}},\"timeline\":{\"lineStyle\":{\"color\":\"#eeeeee\",\"width\":1},\"itemStyle\":{\"normal\":{\"color\":\"#dd6b66\",\"borderWidth\":1},\"emphasis\":{\"color\":\"#a9334c\"}},\"controlStyle\":{\"normal\":{\"color\":\"#ffffff\",\"borderColor\":\"#eeeeee\",\"borderWidth\":0.5},\"emphasis\":{\"color\":\"#ffffff\",\"borderColor\":\"#eeeeee\",\"borderWidth\":0.5}},\"checkpointStyle\":{\"color\":\"#e43c59\",\"borderColor\":\"rgba(194,53,49, 0.5)\"},\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#eeeeee\"}},\"emphasis\":{\"textStyle\":{\"color\":\"#eeeeee\"}}}},\"visualMap\":{\"color\":[\"rgba(216,67,21,1)\",\"rgba(230,74,25,1)\",\"rgba(244,81,30,1)\",\"rgba(255,87,34,1)\",\"rgba(255,112,67,1)\",\"rgba(255,138,101,1)\",\"rgba(255,171,145,1)\",\"rgba(255,204,188,1)\"]},\"dataZoom\":{\"backgroundColor\":\"rgba(47,69,84,0)\",\"dataBackgroundColor\":\"rgba(255,255,255,0.3)\",\"fillerColor\":\"rgba(167,183,204,0.4)\",\"handleColor\":\"#a7b7cc\",\"handleSize\":\"100%\",\"textStyle\":{\"color\":\"#eeeeee\"}},\"markPoint\":{\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#ffffff\"}},\"emphasis\":{\"textStyle\":{\"color\":\"#ffffff\"}}}}}", "remark": "", "is_sys": "1", "user_id": "1", "create_date": "2020-03-18 21:51:55" }, { "id": "233f6959cbe54cef910fd665891bd792", "name": "清新绿", "json_text": "{\"color\":[\"rgba(0,105,92,1)\",\"rgba(0,121,107,1)\",\"rgba(0,137,123,1)\",\"rgba(0,150,136,1)\",\"rgba(38,166,154,1)\",\"rgba(77,182,172,1)\",\"rgba(128,203,196,1)\",\"rgba(178,223,219,1)\"],\"backgroundColor\":\"\",\"textStyle\":{},\"title\":{\"textStyle\":{\"color\":\"#ffffff\"},\"subtextStyle\":{\"color\":\"#ffffff\"}},\"line\":{\"itemStyle\":{\"normal\":{\"borderWidth\":1}},\"lineStyle\":{\"normal\":{\"width\":2}},\"symbolSize\":4,\"symbol\":\"circle\",\"smooth\":false},\"radar\":{\"itemStyle\":{\"normal\":{\"borderWidth\":1}},\"lineStyle\":{\"normal\":{\"width\":2}},\"symbolSize\":4,\"symbol\":\"circle\",\"smooth\":false},\"bar\":{\"itemStyle\":{\"normal\":{\"barBorderWidth\":\"0\",\"barBorderColor\":\"#bdbdbd\"},\"emphasis\":{\"barBorderWidth\":\"0\",\"barBorderColor\":\"#bdbdbd\"}}},\"pie\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"scatter\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"boxplot\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"parallel\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"sankey\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"funnel\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"gauge\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"candlestick\":{\"itemStyle\":{\"normal\":{\"color\":\"#2196f3\",\"color0\":\"#90caf9\",\"borderColor\":\"#f44336\",\"borderColor0\":\"#8bc34a\",\"borderWidth\":\"0.5\"}}},\"graph\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}},\"lineStyle\":{\"normal\":{\"width\":1,\"color\":\"#ffffff\"}},\"symbolSize\":4,\"symbol\":\"circle\",\"smooth\":false,\"color\":[\"#0d47a1\",\"#1565c0\",\"#1976d2\",\"#1e88e5\",\"#2196f3\",\"#42a5f5\",\"#64b5f6\",\"#90caf9\"],\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#ffffff\"}}}},\"map\":{\"itemStyle\":{\"normal\":{\"areaColor\":\"#616161\",\"borderColor\":\"#424242\",\"borderWidth\":\"0.5\"},\"emphasis\":{\"areaColor\":\"#2196f3\",\"borderColor\":\"#424242\",\"borderWidth\":1}},\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#ffffff\"}},\"emphasis\":{\"textStyle\":{\"color\":\"#ffffff\"}}}},\"geo\":{\"itemStyle\":{\"normal\":{\"areaColor\":\"#616161\",\"borderColor\":\"#424242\",\"borderWidth\":\"0.5\"},\"emphasis\":{\"areaColor\":\"#2196f3\",\"borderColor\":\"#424242\",\"borderWidth\":1}},\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#ffffff\"}},\"emphasis\":{\"textStyle\":{\"color\":\"#ffffff\"}}}},\"categoryAxis\":{\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisTick\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisLabel\":{\"show\":true,\"textStyle\":{\"color\":\"#ffffff\"}},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":[\"#ffffff\"]}},\"splitArea\":{\"show\":false,\"areaStyle\":{\"color\":[\"#eeeeee\"]}}},\"valueAxis\":{\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisTick\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisLabel\":{\"show\":true,\"textStyle\":{\"color\":\"#ffffff\"}},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":[\"#ffffff\"]}},\"splitArea\":{\"show\":false,\"areaStyle\":{\"color\":[\"#eeeeee\"]}}},\"logAxis\":{\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisTick\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisLabel\":{\"show\":true,\"textStyle\":{\"color\":\"#ffffff\"}},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":[\"#ffffff\"]}},\"splitArea\":{\"show\":false,\"areaStyle\":{\"color\":[\"#eeeeee\"]}}},\"timeAxis\":{\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisTick\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisLabel\":{\"show\":true,\"textStyle\":{\"color\":\"#ffffff\"}},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":[\"#ffffff\"]}},\"splitArea\":{\"show\":false,\"areaStyle\":{\"color\":[\"#eeeeee\"]}}},\"toolbox\":{\"iconStyle\":{\"normal\":{\"borderColor\":\"#ffffff\"},\"emphasis\":{\"borderColor\":\"#2196f3\"}}},\"legend\":{\"textStyle\":{\"color\":\"#ffffff\"}},\"tooltip\":{\"axisPointer\":{\"lineStyle\":{\"color\":\"#e0e0e0\",\"width\":\"1\"},\"crossStyle\":{\"color\":\"#e0e0e0\",\"width\":\"1\"}}},\"timeline\":{\"lineStyle\":{\"color\":\"#eeeeee\",\"width\":1},\"itemStyle\":{\"normal\":{\"color\":\"#dd6b66\",\"borderWidth\":1},\"emphasis\":{\"color\":\"#a9334c\"}},\"controlStyle\":{\"normal\":{\"color\":\"#ffffff\",\"borderColor\":\"#eeeeee\",\"borderWidth\":0.5},\"emphasis\":{\"color\":\"#ffffff\",\"borderColor\":\"#eeeeee\",\"borderWidth\":0.5}},\"checkpointStyle\":{\"color\":\"#e43c59\",\"borderColor\":\"rgba(194,53,49, 0.5)\"},\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#eeeeee\"}},\"emphasis\":{\"textStyle\":{\"color\":\"#eeeeee\"}}}},\"visualMap\":{\"color\":[\"rgba(0,105,92,1)\",\"rgba(0,121,107,1)\",\"rgba(0,137,123,1)\",\"rgba(0,150,136,1)\",\"rgba(38,166,154,1)\",\"rgba(77,182,172,1)\",\"rgba(128,203,196,1)\",\"rgba(178,223,219,1)\"]},\"dataZoom\":{\"backgroundColor\":\"rgba(47,69,84,0)\",\"dataBackgroundColor\":\"rgba(255,255,255,0.3)\",\"fillerColor\":\"rgba(167,183,204,0.4)\",\"handleColor\":\"#a7b7cc\",\"handleSize\":\"100%\",\"textStyle\":{\"color\":\"#eeeeee\"}},\"markPoint\":{\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#ffffff\"}},\"emphasis\":{\"textStyle\":{\"color\":\"#ffffff\"}}}}}", "remark": "", "is_sys": "1", "user_id": "1", "create_date": "2020-03-18 23:48:18" }, { "id": "56934a06457448e9848fbd1e93b41a9f", "name": "中国红", "json_text": "{\"color\":[\"rgba(183,28,28,1)\",\"rgba(198,40,40,1)\",\"rgba(229,57,53,1)\",\"rgba(244,67,54,1)\",\"rgba(239,83,80,1)\",\"rgba(229,115,115,1)\",\"rgba(239,154,154,1)\",\"rgba(255,205,210,1)\"],\"backgroundColor\":\"\",\"textStyle\":{},\"title\":{\"textStyle\":{\"color\":\"#ffffff\"},\"subtextStyle\":{\"color\":\"#ffffff\"}},\"line\":{\"itemStyle\":{\"normal\":{\"borderWidth\":1}},\"lineStyle\":{\"normal\":{\"width\":2}},\"symbolSize\":4,\"symbol\":\"circle\",\"smooth\":false},\"radar\":{\"itemStyle\":{\"normal\":{\"borderWidth\":1}},\"lineStyle\":{\"normal\":{\"width\":2}},\"symbolSize\":4,\"symbol\":\"circle\",\"smooth\":false},\"bar\":{\"itemStyle\":{\"normal\":{\"barBorderWidth\":\"0\",\"barBorderColor\":\"#bdbdbd\"},\"emphasis\":{\"barBorderWidth\":\"0\",\"barBorderColor\":\"#bdbdbd\"}}},\"pie\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"scatter\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"boxplot\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"parallel\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"sankey\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"funnel\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"gauge\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"candlestick\":{\"itemStyle\":{\"normal\":{\"color\":\"#2196f3\",\"color0\":\"#90caf9\",\"borderColor\":\"#f44336\",\"borderColor0\":\"#8bc34a\",\"borderWidth\":\"0.5\"}}},\"graph\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}},\"lineStyle\":{\"normal\":{\"width\":1,\"color\":\"#ffffff\"}},\"symbolSize\":4,\"symbol\":\"circle\",\"smooth\":false,\"color\":[\"#0d47a1\",\"#1565c0\",\"#1976d2\",\"#1e88e5\",\"#2196f3\",\"#42a5f5\",\"#64b5f6\",\"#90caf9\"],\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#ffffff\"}}}},\"map\":{\"itemStyle\":{\"normal\":{\"areaColor\":\"#616161\",\"borderColor\":\"#424242\",\"borderWidth\":\"0.5\"},\"emphasis\":{\"areaColor\":\"#2196f3\",\"borderColor\":\"#424242\",\"borderWidth\":1}},\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#ffffff\"}},\"emphasis\":{\"textStyle\":{\"color\":\"#ffffff\"}}}},\"geo\":{\"itemStyle\":{\"normal\":{\"areaColor\":\"#616161\",\"borderColor\":\"#424242\",\"borderWidth\":\"0.5\"},\"emphasis\":{\"areaColor\":\"#2196f3\",\"borderColor\":\"#424242\",\"borderWidth\":1}},\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#ffffff\"}},\"emphasis\":{\"textStyle\":{\"color\":\"#ffffff\"}}}},\"categoryAxis\":{\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisTick\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisLabel\":{\"show\":true,\"textStyle\":{\"color\":\"#ffffff\"}},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":[\"#ffffff\"]}},\"splitArea\":{\"show\":false,\"areaStyle\":{\"color\":[\"#eeeeee\"]}}},\"valueAxis\":{\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisTick\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisLabel\":{\"show\":true,\"textStyle\":{\"color\":\"#ffffff\"}},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":[\"#ffffff\"]}},\"splitArea\":{\"show\":false,\"areaStyle\":{\"color\":[\"#eeeeee\"]}}},\"logAxis\":{\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisTick\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisLabel\":{\"show\":true,\"textStyle\":{\"color\":\"#ffffff\"}},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":[\"#ffffff\"]}},\"splitArea\":{\"show\":false,\"areaStyle\":{\"color\":[\"#eeeeee\"]}}},\"timeAxis\":{\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisTick\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisLabel\":{\"show\":true,\"textStyle\":{\"color\":\"#ffffff\"}},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":[\"#ffffff\"]}},\"splitArea\":{\"show\":false,\"areaStyle\":{\"color\":[\"#eeeeee\"]}}},\"toolbox\":{\"iconStyle\":{\"normal\":{\"borderColor\":\"#ffffff\"},\"emphasis\":{\"borderColor\":\"#2196f3\"}}},\"legend\":{\"textStyle\":{\"color\":\"#ffffff\"}},\"tooltip\":{\"axisPointer\":{\"lineStyle\":{\"color\":\"#e0e0e0\",\"width\":\"1\"},\"crossStyle\":{\"color\":\"#e0e0e0\",\"width\":\"1\"}}},\"timeline\":{\"lineStyle\":{\"color\":\"#eeeeee\",\"width\":1},\"itemStyle\":{\"normal\":{\"color\":\"#dd6b66\",\"borderWidth\":1},\"emphasis\":{\"color\":\"#a9334c\"}},\"controlStyle\":{\"normal\":{\"color\":\"#ffffff\",\"borderColor\":\"#eeeeee\",\"borderWidth\":0.5},\"emphasis\":{\"color\":\"#ffffff\",\"borderColor\":\"#eeeeee\",\"borderWidth\":0.5}},\"checkpointStyle\":{\"color\":\"#e43c59\",\"borderColor\":\"rgba(194,53,49, 0.5)\"},\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#eeeeee\"}},\"emphasis\":{\"textStyle\":{\"color\":\"#eeeeee\"}}}},\"visualMap\":{\"color\":[\"rgba(183,28,28,1)\",\"rgba(198,40,40,1)\",\"rgba(229,57,53,1)\",\"rgba(244,67,54,1)\",\"rgba(239,83,80,1)\",\"rgba(229,115,115,1)\",\"rgba(239,154,154,1)\",\"rgba(255,205,210,1)\"]},\"dataZoom\":{\"backgroundColor\":\"rgba(47,69,84,0)\",\"dataBackgroundColor\":\"rgba(255,255,255,0.3)\",\"fillerColor\":\"rgba(167,183,204,0.4)\",\"handleColor\":\"#a7b7cc\",\"handleSize\":\"100%\",\"textStyle\":{\"color\":\"#eeeeee\"}},\"markPoint\":{\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#ffffff\"}},\"emphasis\":{\"textStyle\":{\"color\":\"#ffffff\"}}}}}", "remark": "", "is_sys": "1", "user_id": "1", "create_date": "2020-03-19 00:43:49" }, { "id": "7d9c1dbf205547f087a87c205b2df38a", "name": "经典蓝", "json_text": "{\"color\":[\"rgba(41,98,255,1)\",\"rgba(41,121,255,1)\",\"rgba(68,138,255,1)\",\"rgba(130,177,255,1)\",\"rgba(0,184,212,1)\",\"rgba(0,229,255,1)\",\"rgba(24,255,255,1)\",\"rgba(132,255,255,1)\"],\"backgroundColor\":\"\",\"textStyle\":{},\"title\":{\"textStyle\":{\"color\":\"#ffffff\"},\"subtextStyle\":{\"color\":\"#ffffff\"}},\"line\":{\"itemStyle\":{\"normal\":{\"borderWidth\":1}},\"lineStyle\":{\"normal\":{\"width\":2}},\"symbolSize\":4,\"symbol\":\"circle\",\"smooth\":false},\"radar\":{\"itemStyle\":{\"normal\":{\"borderWidth\":1}},\"lineStyle\":{\"normal\":{\"width\":2}},\"symbolSize\":4,\"symbol\":\"circle\",\"smooth\":false},\"bar\":{\"itemStyle\":{\"normal\":{\"barBorderWidth\":\"0\",\"barBorderColor\":\"#bdbdbd\"},\"emphasis\":{\"barBorderWidth\":\"0\",\"barBorderColor\":\"#bdbdbd\"}}},\"pie\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"scatter\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"boxplot\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"parallel\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"sankey\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"funnel\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"gauge\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"candlestick\":{\"itemStyle\":{\"normal\":{\"color\":\"#2196f3\",\"color0\":\"#90caf9\",\"borderColor\":\"#f44336\",\"borderColor0\":\"#8bc34a\",\"borderWidth\":\"0.5\"}}},\"graph\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}},\"lineStyle\":{\"normal\":{\"width\":1,\"color\":\"#ffffff\"}},\"symbolSize\":4,\"symbol\":\"circle\",\"smooth\":false,\"color\":[\"#0d47a1\",\"#1565c0\",\"#1976d2\",\"#1e88e5\",\"#2196f3\",\"#42a5f5\",\"#64b5f6\",\"#90caf9\"],\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#ffffff\"}}}},\"map\":{\"itemStyle\":{\"normal\":{\"areaColor\":\"#616161\",\"borderColor\":\"#424242\",\"borderWidth\":\"0.5\"},\"emphasis\":{\"areaColor\":\"#2196f3\",\"borderColor\":\"#424242\",\"borderWidth\":1}},\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#ffffff\"}},\"emphasis\":{\"textStyle\":{\"color\":\"#ffffff\"}}}},\"geo\":{\"itemStyle\":{\"normal\":{\"areaColor\":\"#616161\",\"borderColor\":\"#424242\",\"borderWidth\":\"0.5\"},\"emphasis\":{\"areaColor\":\"#2196f3\",\"borderColor\":\"#424242\",\"borderWidth\":1}},\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#ffffff\"}},\"emphasis\":{\"textStyle\":{\"color\":\"#ffffff\"}}}},\"categoryAxis\":{\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisTick\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisLabel\":{\"show\":true,\"textStyle\":{\"color\":\"#ffffff\"}},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":[\"#ffffff\"]}},\"splitArea\":{\"show\":false,\"areaStyle\":{\"color\":[\"#eeeeee\"]}}},\"valueAxis\":{\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisTick\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisLabel\":{\"show\":true,\"textStyle\":{\"color\":\"#ffffff\"}},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":[\"#ffffff\"]}},\"splitArea\":{\"show\":false,\"areaStyle\":{\"color\":[\"#eeeeee\"]}}},\"logAxis\":{\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisTick\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisLabel\":{\"show\":true,\"textStyle\":{\"color\":\"#ffffff\"}},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":[\"#ffffff\"]}},\"splitArea\":{\"show\":false,\"areaStyle\":{\"color\":[\"#eeeeee\"]}}},\"timeAxis\":{\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisTick\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisLabel\":{\"show\":true,\"textStyle\":{\"color\":\"#ffffff\"}},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":[\"#ffffff\"]}},\"splitArea\":{\"show\":false,\"areaStyle\":{\"color\":[\"#eeeeee\"]}}},\"toolbox\":{\"iconStyle\":{\"normal\":{\"borderColor\":\"#ffffff\"},\"emphasis\":{\"borderColor\":\"#2196f3\"}}},\"legend\":{\"textStyle\":{\"color\":\"#ffffff\"}},\"tooltip\":{\"axisPointer\":{\"lineStyle\":{\"color\":\"#e0e0e0\",\"width\":\"1\"},\"crossStyle\":{\"color\":\"#e0e0e0\",\"width\":\"1\"}}},\"timeline\":{\"lineStyle\":{\"color\":\"#eeeeee\",\"width\":1},\"itemStyle\":{\"normal\":{\"color\":\"#dd6b66\",\"borderWidth\":1},\"emphasis\":{\"color\":\"#a9334c\"}},\"controlStyle\":{\"normal\":{\"color\":\"#ffffff\",\"borderColor\":\"#eeeeee\",\"borderWidth\":0.5},\"emphasis\":{\"color\":\"#ffffff\",\"borderColor\":\"#eeeeee\",\"borderWidth\":0.5}},\"checkpointStyle\":{\"color\":\"#e43c59\",\"borderColor\":\"rgba(194,53,49, 0.5)\"},\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#eeeeee\"}},\"emphasis\":{\"textStyle\":{\"color\":\"#eeeeee\"}}}},\"visualMap\":{\"color\":[\"rgba(41,98,255,1)\",\"rgba(41,121,255,1)\",\"rgba(68,138,255,1)\",\"rgba(130,177,255,1)\",\"rgba(0,184,212,1)\",\"rgba(0,229,255,1)\",\"rgba(24,255,255,1)\",\"rgba(132,255,255,1)\"]},\"dataZoom\":{\"backgroundColor\":\"rgba(47,69,84,0)\",\"dataBackgroundColor\":\"rgba(255,255,255,0.3)\",\"fillerColor\":\"rgba(167,183,204,0.4)\",\"handleColor\":\"#a7b7cc\",\"handleSize\":\"100%\",\"textStyle\":{\"color\":\"#eeeeee\"}},\"markPoint\":{\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#ffffff\"}},\"emphasis\":{\"textStyle\":{\"color\":\"#ffffff\"}}}}}", "remark": "", "is_sys": "1", "user_id": "1", "create_date": "2020-03-18 21:31:22" }, { "id": "fbadca3eb65544e1a62831eb228f1768", "name": "酷炫紫", "json_text": "{\"color\":[\"rgba(69,39,160,1)\",\"rgba(81,45,168,1)\",\"rgba(94,53,177,1)\",\"rgba(103,58,183,1)\",\"rgba(126,87,194,1)\",\"rgba(149,117,205,1)\",\"rgba(179,157,219,1)\",\"rgba(209,196,233,1)\"],\"backgroundColor\":\"\",\"textStyle\":{},\"title\":{\"textStyle\":{\"color\":\"#ffffff\"},\"subtextStyle\":{\"color\":\"#ffffff\"}},\"line\":{\"itemStyle\":{\"normal\":{\"borderWidth\":1}},\"lineStyle\":{\"normal\":{\"width\":2}},\"symbolSize\":4,\"symbol\":\"circle\",\"smooth\":false},\"radar\":{\"itemStyle\":{\"normal\":{\"borderWidth\":1}},\"lineStyle\":{\"normal\":{\"width\":2}},\"symbolSize\":4,\"symbol\":\"circle\",\"smooth\":false},\"bar\":{\"itemStyle\":{\"normal\":{\"barBorderWidth\":\"0\",\"barBorderColor\":\"#bdbdbd\"},\"emphasis\":{\"barBorderWidth\":\"0\",\"barBorderColor\":\"#bdbdbd\"}}},\"pie\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"scatter\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"boxplot\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"parallel\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"sankey\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"funnel\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"gauge\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"candlestick\":{\"itemStyle\":{\"normal\":{\"color\":\"#2196f3\",\"color0\":\"#90caf9\",\"borderColor\":\"#f44336\",\"borderColor0\":\"#8bc34a\",\"borderWidth\":\"0.5\"}}},\"graph\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}},\"lineStyle\":{\"normal\":{\"width\":1,\"color\":\"#ffffff\"}},\"symbolSize\":4,\"symbol\":\"circle\",\"smooth\":false,\"color\":[\"#0d47a1\",\"#1565c0\",\"#1976d2\",\"#1e88e5\",\"#2196f3\",\"#42a5f5\",\"#64b5f6\",\"#90caf9\"],\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#ffffff\"}}}},\"map\":{\"itemStyle\":{\"normal\":{\"areaColor\":\"#616161\",\"borderColor\":\"#424242\",\"borderWidth\":\"0.5\"},\"emphasis\":{\"areaColor\":\"#2196f3\",\"borderColor\":\"#424242\",\"borderWidth\":1}},\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#ffffff\"}},\"emphasis\":{\"textStyle\":{\"color\":\"#ffffff\"}}}},\"geo\":{\"itemStyle\":{\"normal\":{\"areaColor\":\"#616161\",\"borderColor\":\"#424242\",\"borderWidth\":\"0.5\"},\"emphasis\":{\"areaColor\":\"#2196f3\",\"borderColor\":\"#424242\",\"borderWidth\":1}},\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#ffffff\"}},\"emphasis\":{\"textStyle\":{\"color\":\"#ffffff\"}}}},\"categoryAxis\":{\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisTick\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisLabel\":{\"show\":true,\"textStyle\":{\"color\":\"#ffffff\"}},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":[\"#ffffff\"]}},\"splitArea\":{\"show\":false,\"areaStyle\":{\"color\":[\"#eeeeee\"]}}},\"valueAxis\":{\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisTick\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisLabel\":{\"show\":true,\"textStyle\":{\"color\":\"#ffffff\"}},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":[\"#ffffff\"]}},\"splitArea\":{\"show\":false,\"areaStyle\":{\"color\":[\"#eeeeee\"]}}},\"logAxis\":{\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisTick\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisLabel\":{\"show\":true,\"textStyle\":{\"color\":\"#ffffff\"}},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":[\"#ffffff\"]}},\"splitArea\":{\"show\":false,\"areaStyle\":{\"color\":[\"#eeeeee\"]}}},\"timeAxis\":{\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisTick\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisLabel\":{\"show\":true,\"textStyle\":{\"color\":\"#ffffff\"}},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":[\"#ffffff\"]}},\"splitArea\":{\"show\":false,\"areaStyle\":{\"color\":[\"#eeeeee\"]}}},\"toolbox\":{\"iconStyle\":{\"normal\":{\"borderColor\":\"#ffffff\"},\"emphasis\":{\"borderColor\":\"#2196f3\"}}},\"legend\":{\"textStyle\":{\"color\":\"#ffffff\"}},\"tooltip\":{\"axisPointer\":{\"lineStyle\":{\"color\":\"#e0e0e0\",\"width\":\"1\"},\"crossStyle\":{\"color\":\"#e0e0e0\",\"width\":\"1\"}}},\"timeline\":{\"lineStyle\":{\"color\":\"#eeeeee\",\"width\":1},\"itemStyle\":{\"normal\":{\"color\":\"#dd6b66\",\"borderWidth\":1},\"emphasis\":{\"color\":\"#a9334c\"}},\"controlStyle\":{\"normal\":{\"color\":\"#ffffff\",\"borderColor\":\"#eeeeee\",\"borderWidth\":0.5},\"emphasis\":{\"color\":\"#ffffff\",\"borderColor\":\"#eeeeee\",\"borderWidth\":0.5}},\"checkpointStyle\":{\"color\":\"#e43c59\",\"borderColor\":\"rgba(194,53,49, 0.5)\"},\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#eeeeee\"}},\"emphasis\":{\"textStyle\":{\"color\":\"#eeeeee\"}}}},\"visualMap\":{\"color\":[\"rgba(69,39,160,1)\",\"rgba(81,45,168,1)\",\"rgba(94,53,177,1)\",\"rgba(103,58,183,1)\",\"rgba(126,87,194,1)\",\"rgba(149,117,205,1)\",\"rgba(179,157,219,1)\",\"rgba(209,196,233,1)\"]},\"dataZoom\":{\"backgroundColor\":\"rgba(47,69,84,0)\",\"dataBackgroundColor\":\"rgba(255,255,255,0.3)\",\"fillerColor\":\"rgba(167,183,204,0.4)\",\"handleColor\":\"#a7b7cc\",\"handleSize\":\"100%\",\"textStyle\":{\"color\":\"#eeeeee\"}},\"markPoint\":{\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#ffffff\"}},\"emphasis\":{\"textStyle\":{\"color\":\"#ffffff\"}}}}}", "remark": "", "is_sys": "1", "user_id": "1", "create_date": "2020-03-18 23:50:22" }, { "id": "1fb91eabf6a1409fa504c8876c2fe7fc", "name": "wk theme", "json_text": "{\"color\":[\"#0d47a1\",\"#1565c0\",\"#1976d2\",\"#1e88e5\",\"#2196f3\",\"#42a5f5\",\"#64b5f6\",\"#90caf9\"],\"backgroundColor\":\"\",\"textStyle\":{},\"title\":{\"textStyle\":{\"color\":\"#ffffff\"},\"subtextStyle\":{\"color\":\"#ffffff\"}},\"line\":{\"itemStyle\":{\"normal\":{\"borderWidth\":1}},\"lineStyle\":{\"normal\":{\"width\":2}},\"symbolSize\":4,\"symbol\":\"circle\",\"smooth\":false},\"radar\":{\"itemStyle\":{\"normal\":{\"borderWidth\":1}},\"lineStyle\":{\"normal\":{\"width\":2}},\"symbolSize\":4,\"symbol\":\"circle\",\"smooth\":false},\"bar\":{\"itemStyle\":{\"normal\":{\"barBorderWidth\":\"0\",\"barBorderColor\":\"#bdbdbd\"},\"emphasis\":{\"barBorderWidth\":\"0\",\"barBorderColor\":\"#bdbdbd\"}}},\"pie\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"scatter\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"boxplot\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"parallel\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"sankey\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"funnel\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"gauge\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"},\"emphasis\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}}},\"candlestick\":{\"itemStyle\":{\"normal\":{\"color\":\"#2196f3\",\"color0\":\"#90caf9\",\"borderColor\":\"#f44336\",\"borderColor0\":\"#8bc34a\",\"borderWidth\":\"0.5\"}}},\"graph\":{\"itemStyle\":{\"normal\":{\"borderWidth\":\"0\",\"borderColor\":\"#bdbdbd\"}},\"lineStyle\":{\"normal\":{\"width\":1,\"color\":\"#ffffff\"}},\"symbolSize\":4,\"symbol\":\"circle\",\"smooth\":false,\"color\":[\"#0d47a1\",\"#1565c0\",\"#1976d2\",\"#1e88e5\",\"#2196f3\",\"#42a5f5\",\"#64b5f6\",\"#90caf9\"],\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#ffffff\"}}}},\"map\":{\"itemStyle\":{\"normal\":{\"areaColor\":\"#616161\",\"borderColor\":\"#424242\",\"borderWidth\":\"0.5\"},\"emphasis\":{\"areaColor\":\"#2196f3\",\"borderColor\":\"#424242\",\"borderWidth\":1}},\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#ffffff\"}},\"emphasis\":{\"textStyle\":{\"color\":\"#ffffff\"}}}},\"geo\":{\"itemStyle\":{\"normal\":{\"areaColor\":\"#616161\",\"borderColor\":\"#424242\",\"borderWidth\":\"0.5\"},\"emphasis\":{\"areaColor\":\"#2196f3\",\"borderColor\":\"#424242\",\"borderWidth\":1}},\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#ffffff\"}},\"emphasis\":{\"textStyle\":{\"color\":\"#ffffff\"}}}},\"categoryAxis\":{\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisTick\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisLabel\":{\"show\":true,\"textStyle\":{\"color\":\"#ffffff\"}},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":[\"#ffffff\"]}},\"splitArea\":{\"show\":false,\"areaStyle\":{\"color\":[\"#eeeeee\"]}}},\"valueAxis\":{\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisTick\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisLabel\":{\"show\":true,\"textStyle\":{\"color\":\"#ffffff\"}},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":[\"#ffffff\"]}},\"splitArea\":{\"show\":false,\"areaStyle\":{\"color\":[\"#eeeeee\"]}}},\"logAxis\":{\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisTick\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisLabel\":{\"show\":true,\"textStyle\":{\"color\":\"#ffffff\"}},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":[\"#ffffff\"]}},\"splitArea\":{\"show\":false,\"areaStyle\":{\"color\":[\"#eeeeee\"]}}},\"timeAxis\":{\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisTick\":{\"show\":true,\"lineStyle\":{\"color\":\"#ffffff\"}},\"axisLabel\":{\"show\":true,\"textStyle\":{\"color\":\"#ffffff\"}},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":[\"#ffffff\"]}},\"splitArea\":{\"show\":false,\"areaStyle\":{\"color\":[\"#eeeeee\"]}}},\"toolbox\":{\"iconStyle\":{\"normal\":{\"borderColor\":\"#ffffff\"},\"emphasis\":{\"borderColor\":\"#2196f3\"}}},\"legend\":{\"textStyle\":{\"color\":\"#ffffff\"}},\"tooltip\":{\"axisPointer\":{\"lineStyle\":{\"color\":\"#e0e0e0\",\"width\":\"1\"},\"crossStyle\":{\"color\":\"#e0e0e0\",\"width\":\"1\"}}},\"timeline\":{\"lineStyle\":{\"color\":\"#eeeeee\",\"width\":1},\"itemStyle\":{\"normal\":{\"color\":\"#dd6b66\",\"borderWidth\":1},\"emphasis\":{\"color\":\"#a9334c\"}},\"controlStyle\":{\"normal\":{\"color\":\"#ffffff\",\"borderColor\":\"#eeeeee\",\"borderWidth\":0.5},\"emphasis\":{\"color\":\"#ffffff\",\"borderColor\":\"#eeeeee\",\"borderWidth\":0.5}},\"checkpointStyle\":{\"color\":\"#e43c59\",\"borderColor\":\"rgba(194,53,49, 0.5)\"},\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#eeeeee\"}},\"emphasis\":{\"textStyle\":{\"color\":\"#eeeeee\"}}}},\"visualMap\":{\"color\":[\"#0d47a1\",\"#1565c0\",\"#1976d2\",\"#1e88e5\",\"#2196f3\",\"#42a5f5\",\"#64b5f6\",\"#90caf9\"]},\"dataZoom\":{\"backgroundColor\":\"rgba(47,69,84,0)\",\"dataBackgroundColor\":\"rgba(255,255,255,0.3)\",\"fillerColor\":\"rgba(167,183,204,0.4)\",\"handleColor\":\"#a7b7cc\",\"handleSize\":\"100%\",\"textStyle\":{\"color\":\"#eeeeee\"}},\"markPoint\":{\"label\":{\"normal\":{\"textStyle\":{\"color\":\"#ffffff\"}},\"emphasis\":{\"textStyle\":{\"color\":\"#ffffff\"}}}}}", "remark": "", "is_sys": "0", "user_id": "fa98320cce104d899bfa95225d110baa", "create_date": "2023-02-27 10:37:04" }]
}
