/**
 * @Description: 构造indexDB
 * @Param: options：构造参数对象，name：数据库名称，version：版本号，callback：回调函数
 * @return:
 * @Author: Mr.WK
 * @Date: 2023/4/21
 */
/**示例代码
 var oTxsIDB=new TxsIDB({
    name:'',
    version:'',
    callback:function(){

    }
});*/
function TxsIDB(options) {

    var _this = this
    _this.name = "TxsDB"
    _this.version = 1
    _this.callback = null
    if (options) {
        _this.name = options.name
        _this.version = options.version
        _this.callback = options.callback
    }
    _this.TxsDB = {}
    _this.oIDBRequest = window.indexedDB.open(_this.name, _this.version)

    _this.oIDBRequest.onerror = function (event) {
        console.log('数据库打开报错')
    }
    _this.oIDBRequest.onsuccess = function (event) {
        _this.TxsDB = event.target.result
        console.log("onsuccess")
        if (_this.callback) {
            _this.callback()
        }
    }

    _this.oIDBRequest.onupgradeneeded = function (event) {
        console.log("onupgradeneeded")
        _this.TxsDB = event.target.result
        var oMixObjectStore
        if (!_this.TxsDB.objectStoreNames.contains('stage_background_table')) {
            oMixObjectStore = _this.TxsDB.createObjectStore('stage_background_table', { keyPath: 'pageId' })
            oMixObjectStore.createIndex('scenepreview', 'pageId', { unique: false })
        }
    }

    _this.fnPutDB = function (linedata, table, callback) {
        var oPutRequest = _this.TxsDB.transaction([table], 'readwrite')
            .objectStore(table)
            .put(linedata)
        oPutRequest.onsuccess = function (event) {
            if (callback) {
                callback({ code: 1 })
            }
        }
        oPutRequest.onerror = function (event) {
            if (callback) {
                callback({ code: 0 })
            }
        }
    }
    _this.fnReadDB = function (data, table, callback) {
        var oReadRequest
        if (data == "") {
            oReadRequest = _this.TxsDB.transaction(table).objectStore(table).openCursor()
        } else {
            //针对keyPath
            var oOS = _this.TxsDB.transaction([table]).objectStore(table)
            //oReadRequest = TxsDB.transaction([table]).objectStore(table).get(id);
            oReadRequest = oOS.index('scenepreview').openCursor(IDBKeyRange.only(data))
        }
        oReadRequest.onerror = function (event) {
            if (callback) {
                callback({ code: 0 })
            }
        }
        oReadRequest.onsuccess = function (event) {
            if (data == "") {
                var cursor = event.target.result
                if (cursor) {
                    if (callback) {
                        callback({ code: 1, data: cursor })
                    }
                    cursor.continue()
                } else {
                    console.log('no data')
                }
            } else {
                if (oReadRequest.result) {
                    if (callback) {
                        callback({ code: 1, data: oReadRequest.result })
                    }
                } else {
                    if (callback) {
                        callback({ code: 1, data: null })
                    }
                }
            }
        }
    }
}
